/*
 * Decompiled with CFR 0.152.
 */
package xueluoanping.teastory.resource;

import cloud.lemonslice.teastory.block.crops.VineType;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.AbstractPackResources;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.metadata.MetadataSectionSerializer;
import net.minecraft.server.packs.resources.IoSupplier;
import net.minecraftforge.forgespi.locating.IModFile;
import org.jetbrains.annotations.Nullable;
import xueluoanping.teastory.TeaStory;
import xueluoanping.teastory.variant.Planks;

public class ClientModFilePackResources
extends AbstractPackResources {
    protected final String sourcePath;
    protected final IModFile modFile;
    protected final Gson gson = new Gson();

    public ClientModFilePackResources(String name, IModFile modFile, String sourcePath) {
        super(name, true);
        this.sourcePath = sourcePath;
        this.modFile = modFile;
    }

    @Nullable
    public <T> T m_5550_(MetadataSectionSerializer<T> pDeserializer) throws IOException {
        JsonObject jsonObject = new JsonObject();
        JsonObject pack = new JsonObject();
        pack.addProperty("description", "Tea the Story Auto Client");
        pack.addProperty("pack_format", (Number)9);
        jsonObject.add("pack", (JsonElement)pack);
        return (T)ClientModFilePackResources.m_10214_(pDeserializer, (InputStream)((InputStream)ClientModFilePackResources.jsonObjectToIoSupplier(jsonObject).m_247737_()));
    }

    @Nullable
    public IoSupplier<InputStream> m_8017_(String ... pElements) {
        return null;
    }

    @Nullable
    public IoSupplier<InputStream> m_214146_(PackType pPackType, ResourceLocation pLocation) {
        return null;
    }

    public static IoSupplier<InputStream> jsonObjectToIoSupplier(JsonObject jsonObject) {
        String jsonString = jsonObject.toString();
        ByteArrayInputStream inputStream = new ByteArrayInputStream(jsonString.getBytes());
        return () -> inputStream;
    }

    public static IoSupplier<InputStream> stringToIoSupplier(String jsonString) {
        ByteArrayInputStream inputStream = new ByteArrayInputStream(jsonString.getBytes());
        return () -> inputStream;
    }

    public JsonObject getJson(Path filePath) {
        try {
            return (JsonObject)this.gson.fromJson(Files.readString(filePath), JsonObject.class);
        }
        catch (IOException e) {
            TeaStory.logger("Error read in %s".formatted(filePath));
            return new JsonObject();
        }
    }

    public void m_8031_(PackType type, String namespace, String path, PackResources.ResourceOutput resourceOutput) {
        if (namespace.equals("teastory") && path.equals("blockstates")) {
            Path trellisPath = this.modFile.findResource(new String[]{"templates/assets/blockstates/trellis.json"});
            Path bittergourdTrellisPath = this.modFile.findResource(new String[]{"templates/assets/blockstates/trellis_bitter_gourd.json"});
            Path cucumberTrellisPath = this.modFile.findResource(new String[]{"templates/assets/blockstates/trellis_cucumber.json"});
            Path grapeTrellisPath = this.modFile.findResource(new String[]{"templates/assets/blockstates/trellis_grape.json"});
            JsonObject trellis = this.getJson(trellisPath);
            JsonObject bittergourdTrellis = this.getJson(bittergourdTrellisPath);
            JsonObject cucumberTrellis = this.getJson(cucumberTrellisPath);
            JsonObject grapeTrellis = this.getJson(grapeTrellisPath);
            HashMap<VineType, JsonObject> vineTypeJsonObjectMap = new HashMap<VineType, JsonObject>();
            vineTypeJsonObjectMap.put(VineType.BITTER_GOURD, bittergourdTrellis);
            vineTypeJsonObjectMap.put(VineType.CUCUMBER, cucumberTrellis);
            vineTypeJsonObjectMap.put(VineType.GRAPE, grapeTrellis);
            String preholder = "\\{trellis}";
            Planks.TrellisBlockMap.forEach((resourceLocation, blockBlockPair) -> {
                String name = resourceLocation.m_135815_();
                resourceOutput.accept((Object)TeaStory.rl("blockstates/%s.json".formatted(name)), ClientModFilePackResources.stringToIoSupplier(trellis.toString().replaceAll(preholder, name)));
                for (VineType value : VineType.values()) {
                    resourceOutput.accept((Object)TeaStory.rl("blockstates/%s.json".formatted(name + "_with_" + value.getName() + "_vine")), ClientModFilePackResources.stringToIoSupplier(trellis.toString().replaceAll(preholder, name)));
                }
            });
        } else if (namespace.equals("teastory") && path.equals("models")) {
            List<String> list = List.of("bar", "center", "post", "post_up", "support");
            HashMap<String, JsonObject> typeMap = new HashMap<String, JsonObject>();
            for (String s : list) {
                typeMap.put(s, this.getJson(this.modFile.findResource(new String[]{"templates/assets/models/block/trellis_%s.json".formatted(s)})));
            }
            JsonObject inventoryjson = this.getJson(this.modFile.findResource(new String[]{"templates/assets/models/item/trellis.json"}));
            Planks.TrellisBlockMap.forEach((resourceLocation, blockBlockPair) -> {
                String name = resourceLocation.m_135815_();
                typeMap.forEach((s, jsonObject) -> resourceOutput.accept((Object)TeaStory.rl("models/block/%s_%s.json".formatted(name, s)), ClientModFilePackResources.stringToIoSupplier(jsonObject.toString())));
                resourceOutput.accept((Object)TeaStory.rl("models/item/%s.json".formatted(name)), ClientModFilePackResources.stringToIoSupplier(inventoryjson.toString()));
            });
        }
    }

    public Set<String> m_5698_(PackType pType) {
        return Set.of("teastory");
    }

    public void close() {
    }
}

